# R Code UDU Criteria USP <905> Heat Map
# January 2017
# Lori B. Pfahler (lori.pfahler@merck.com)
# 
# Programmed using the following R Version:
# R version 3.3.2 (2016-10-31) -- "Sincere Pumpkin Patch"
# Copyright (C) 2016 The R Foundation for Statistical Computing
# Platform: x86_64-w64-mingw32/x64 (64-bit)

# Run UDU simulation for a range of standard deviations and 
# means to create a heatmap used in book.
# Requires simUDUTest function in file:
# "USP 905 UDU Simulation R Code.R"

for (i in seq(0.1, 10, 0.1))
{
  for(j in seq(90, 110, 1))
  { 
    runA <- simUDUTest(reps=5000, Target=100, avg=j, sd=i, L1=15, L2=25)
    if (i==0.1&j==90)
      UDUResults <- c(j,i,mean(runA$PassOverall))
    else
    {
      currentResults <- c(j,i,mean(runA$PassOverall))
      UDUResults <- rbind(UDUResults, currentResults)
    }
  }
}
colnames(UDUResults) <- c("Avg", "SD", "Pass")
UDUResults <- data.frame(UDUResults, row.names=NULL)

# graphics device for better copy/paste
windows(width=9, height=7)

# Heatmap of UDU Test
# rows are standard deviations and columns are means
UDUResults.mat <- matrix(UDUResults[,3], nrow=21, ncol=100)
x <- seq(90, 110)
y <-seq(0.1, 10, 0.1)
filled.contour(x, y, UDUResults.mat, levels=c(0, 0.8, 0.9, 0.95, 0.99,1), ylim=c(0.1,10),
               col=c("red", "orange", "yellow", "light green", "green"), ylab="Standard Deviation (within Batch)",
               xlab="Process Average (% of Label Claim)",
               main="Probability of Passing UDU Test",
               plot.axes={axis(2, at=c(seq(1, 10, 1)), las=2); abline(h=c(seq(1, 9, 1)),col="white",lty=2, lwd=1); 
                 axis(1, at=c(seq(90, 110, 1)), las=2); abline(v=c(seq(91,109,1)), col="white", lty=2, lwd=1)},
               key.axes=axis(4, at=c(0.80, 0.90, 0.95, 0.99)))

